VERSION 5.00
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "Mscomct2.ocx"
Begin VB.Form AdjustText 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Adjust Selected Callouts"
   ClientHeight    =   1785
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   4665
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1785
   ScaleWidth      =   4665
   ShowInTaskbar   =   0   'False
   Begin MSComCtl2.UpDown UpDown 
      Height          =   735
      Left            =   600
      TabIndex        =   7
      Top             =   480
      Width           =   240
      _ExtentX        =   423
      _ExtentY        =   1296
      _Version        =   393216
      Enabled         =   -1  'True
   End
   Begin MSComCtl2.UpDown LeftRight 
      Height          =   240
      Left            =   960
      TabIndex        =   6
      Top             =   1200
      Width           =   735
      _ExtentX        =   1296
      _ExtentY        =   423
      _Version        =   393216
      Orientation     =   1
      Enabled         =   -1  'True
   End
   Begin VB.CommandButton cmdReset 
      Caption         =   "&Reset"
      Height          =   375
      Left            =   3360
      TabIndex        =   3
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Frame frmMove 
      Caption         =   "Move Text"
      Height          =   1455
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   3135
      Begin VB.TextBox txtStep 
         Height          =   375
         Left            =   2040
         TabIndex        =   5
         Text            =   "Text1"
         Top             =   480
         Width           =   735
      End
      Begin VB.Label lblStep 
         Caption         =   "Step (mm)"
         Height          =   375
         Left            =   840
         TabIndex        =   4
         Top             =   480
         Width           =   1095
      End
   End
   Begin VB.CommandButton CancelButton 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3360
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   3360
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "AdjustText"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit


Private app As ProDESKTOP

Private doc As DrawingDocument
Private drg As aDrawing

Private obSetCls As ObjectSetClass
Private itCls As ItClass
Private vectorCls As VectorClass

Private selection As ObjectSet

Private Type Note
    text As aCalloutGroup
    pos As zVector
End Type

Private stepVector As zVector
Private stepVal As Double

Private noteArray() As Note
Private resetPositionsArray() As zVector

Private activeDoc As Boolean


Private Sub CancelButton_Click()
    ResetNotePositions
    Me.Hide
    Unload Me
End Sub

Private Sub cmdReset_Click()
    ResetNotePositions
End Sub

Private Sub LeftRight_DownClick()
    
    On Error GoTo BadValue
    stepVal = -CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(stepVal, 0#, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
End Sub

Private Sub LeftRight_UpClick()

    On Error GoTo BadValue
    stepVal = CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(stepVal, 0#, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
End Sub

Private Sub UpDown_DownClick()

    On Error GoTo BadValue
    stepVal = -CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(0#, stepVal, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
End Sub

Private Sub UpDown_UpClick()

    On Error GoTo BadValue
    stepVal = CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(0#, stepVal, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
End Sub

Private Sub Form_Activate()
    
    Set app = CreateObject("ProDESKTOP.Application")
    app.SetVisible True
    
    Set doc = app.GetActiveDoc
    Set drg = doc.GetDrawing
    
    Set obSetCls = app.GetClass("ObjectSet")
    Set itCls = app.GetClass("it")
    Set vectorCls = app.GetClass("Vector")
    
    If GetNotesCheck Then
        Me.UpDown.Enabled = True
        Me.LeftRight.Enabled = True
        CreateNoteArray
    Else
        Me.UpDown.Enabled = False
        Me.LeftRight.Enabled = False
    End If

End Sub

Private Sub Form_Initialize()
    txtStep.text = 1
    Me.Caption = LoadResString(142)
    OKButton.Caption = LoadResString(143)
    CancelButton.Caption = LoadResString(144)
    cmdReset.Caption = LoadResString(145)
    
End Sub


Private Function GetNotesCheck() As Boolean
    GetNotesCheck = False
    
    Set selection = obSetCls.CreateAObjectSet()
    Set selection = doc.GetSelection("NoteCallout")
    If selection.GetCount = 0 Then
        GetNotesCheck = False
    Else
        GetNotesCheck = True
    End If
End Function


Private Sub CreateNoteArray()

    ReDim noteArray(selection.GetCount)
    ReDim resetPositionsArray(selection.GetCount)
    
    Dim api As helm
    Set api = app.TakeHelm
    
    
    Dim it As iterator, i As Integer
    i = 0
    Set it = itCls.CreateAObjectIt(selection)
    it.start
    
    Dim currentNote As aCalloutGroup, noteC As aNoteCallout
    Do While it.IsActive
        Set noteC = it.Current
        Set currentNote = noteC.GetParent("CalloutGroup")
        Set noteArray(i).text = currentNote
        Set noteArray(i).pos = currentNote.GetControlPoint(topCenter)
        it.Next
        i = i + 1
    Loop
    
    For i = 0 To UBound(resetPositionsArray)
        Set resetPositionsArray(i) = noteArray(i).pos
    Next
    
    app.ReleaseHelm api
    
End Sub

Private Sub MoveNote()
    Dim i As Integer
    Dim pos As zVector
    Dim api As helm
    Set api = app.TakeHelm
    i = 0
    For i = 0 To UBound(noteArray) - 1
        Set pos = noteArray(i).text.GetControlPoint(topCenter)
        Set pos = pos.Add(stepVector)
        noteArray(i).text.SetControlPoint topCenter, pos
    Next
    api.CommitCalls LoadResString(146), False
    app.ReleaseHelm api
End Sub

Private Sub ResetNotePositions()
    Dim i As Integer
    Dim pos As zVector
    Dim currentPos As zVector
    Dim x1 As Double, x2 As Double
    Dim y1 As Double, y2 As Double
    Dim nl As String
    nl = Chr(10) & Chr(13)
    
    Dim api As helm
    Set api = app.TakeHelm
    If Not selection.GetCount = 0 Then
        i = 0
        For i = 0 To UBound(resetPositionsArray) - 1
            Set pos = resetPositionsArray(i)
            noteArray(i).text.SetControlPoint topCenter, pos
        Next
    End If
    api.CommitCalls LoadResString(146), False
    app.ReleaseHelm api
    
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If GetNotesCheck Then
        Me.UpDown.Enabled = True
        Me.LeftRight.Enabled = True
        CreateNoteArray
    Else
        Me.UpDown.Enabled = False
        Me.LeftRight.Enabled = False
    End If
End Sub

Private Sub OKButton_Click()
    Me.Hide
    Unload Me
End Sub
